/** @file   UltimateBadAssAlien.h
 * @brief   Declaration of UltimateBadAssAlien class.
 * @version $Revision
 * @date    $Date: 2006/07/13 16:25:09 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_ULTIMATEBADASSALIEN_H
#define H_WWW_ULTIMATEBADASSALIEN_H

#include "Alien.h"


namespace WeWantWar {

/** @class  UltimateBadAssAlien
 * @brief   The final boss enemy.
 * @author  Tomi Lamminsaari
 *
 */
class UltimateBadAssAlien : public Alien
{
public:

  ///
  /// Constants, datatypes and static methods
  /// =======================================

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor.
   */
  UltimateBadAssAlien();

  /** Destructor
   */
  virtual ~UltimateBadAssAlien();

private:
  UltimateBadAssAlien( const UltimateBadAssAlien& aAnother );
  UltimateBadAssAlien& operator= ( const UltimateBadAssAlien& aAnother );
public:

  ///
  /// Inherited methods
  /// =================

  /** From GameObject
   */
  virtual void update();
  
  /** From GameObject
   */
  virtual void makeSound( GameObject::SoundID aSoundId ) const;

  /** From GameObject
   */
  virtual bool hitByBullet( Bullet* aBullet );
  
  /** We implement this so that we can inform the ai-object when
   * we got shot.
   * @param     pB                Pointer to Bullet that hit us.
   * @return    <code>true</code> if we died
   */
  virtual bool causeDamage( Bullet* pB );
  
  /** From GameObject
   */
  virtual void kill();
  
  /** From GameObject
   */
  virtual ObjectID::Type objectType() const;

  ///
  /// New public methods
  /// ==================


  ///
  /// Getter methods
  /// ==============
  
  


protected:
  ///
  /// Protected interface
  /// ===================
  
  /** Sets the requested animation.
   * @param   aAnimId           Id of the animation.
   */
  void setCorrectAnimation( int aAnimId );
  
  /** Shoots
   */
  void attack();
  
  /** Attacks with secondary weapon.
   */
  void attack2();
  

protected:
  ///
  /// Data members
  /// ============

  /** Walking speed. */
  eng2d::Vec2D iWalkVector;
  
  int iShieldCounter;
};

};  // end of namespace

#endif
